/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.layers;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.crafting.api.components.IRecipeComponents;
import dev.compactmods.crafting.api.recipe.layers.IRecipeBlocks;
import dev.compactmods.crafting.api.recipe.layers.IRecipeLayer;
import dev.compactmods.crafting.api.recipe.layers.ISymmetricalLayer;
import dev.compactmods.crafting.api.recipe.layers.RecipeLayerType;
import dev.compactmods.crafting.api.recipe.layers.dim.IDynamicSizedRecipeLayer;
import dev.compactmods.crafting.core.CCLayerTypes;
import dev.compactmods.crafting.util.BlockSpaceUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class HollowComponentRecipeLayer
extends ForgeRegistryEntry<RecipeLayerType<?>>
implements IRecipeLayer,
IDynamicSizedRecipeLayer,
ISymmetricalLayer,
RecipeLayerType<HollowComponentRecipeLayer> {
    private final String componentKey;
    private AABB recipeDimensions;
    private Set<BlockPos> filledPositions;
    public static final Codec<HollowComponentRecipeLayer> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("wall").forGetter(HollowComponentRecipeLayer::getComponent)).apply((Applicative)i, HollowComponentRecipeLayer::new));

    public HollowComponentRecipeLayer() {
        this.componentKey = null;
        this.filledPositions = Collections.emptySet();
    }

    public HollowComponentRecipeLayer(String component) {
        this.componentKey = component;
        this.filledPositions = Collections.emptySet();
    }

    @Override
    public RecipeLayerType<?> getType() {
        return (RecipeLayerType)CCLayerTypes.HOLLOW_LAYER_TYPE.get();
    }

    @Override
    public Set<String> getComponents() {
        return ImmutableSet.of((Object)this.componentKey);
    }

    @Override
    public Map<String, Integer> getComponentTotals() {
        return Collections.singletonMap(this.componentKey, this.getNumberFilledPositions());
    }

    @Override
    public Optional<String> getComponentForPosition(BlockPos pos) {
        if (this.filledPositions.contains(pos)) {
            return Optional.ofNullable(this.componentKey);
        }
        return Optional.empty();
    }

    @Override
    public Stream<BlockPos> getPositionsForComponent(String component) {
        if (!component.equals(this.componentKey)) {
            return Stream.empty();
        }
        return this.filledPositions.stream();
    }

    public int getNumberFilledPositions() {
        return this.filledPositions.size();
    }

    @Override
    public boolean matches(IRecipeComponents components, IRecipeBlocks blocks) {
        Map<String, Integer> totalsInWorld;
        if (!blocks.allIdentified()) {
            boolean anyNonAir = blocks.getUnmappedPositions().map(blocks::getStateAtPosition).anyMatch(state -> !state.m_60795_());
            if (anyNonAir) {
                return false;
            }
        }
        if (!(totalsInWorld = blocks.getKnownComponentTotals()).containsKey(this.componentKey)) {
            return false;
        }
        if (totalsInWorld.size() > 1) {
            boolean everythingElseEmpty = totalsInWorld.keySet().stream().filter(c -> !c.equals(this.componentKey)).allMatch(components::isEmptyBlock);
            if (!everythingElseEmpty) {
                return false;
            }
        }
        int targetCount = totalsInWorld.get(this.componentKey);
        int layerCount = this.filledPositions.size();
        return layerCount == targetCount;
    }

    @Override
    public void setRecipeDimensions(AABB dimensions) {
        this.recipeDimensions = dimensions;
        this.recalculateRequirements();
    }

    @Override
    public void recalculateRequirements() {
        this.filledPositions = BlockSpaceUtil.getWallPositions(this.recipeDimensions).map(BlockPos::m_7949_).collect(Collectors.toSet());
    }

    public String getComponent() {
        return this.componentKey;
    }

    @Override
    public Codec<HollowComponentRecipeLayer> getCodec() {
        return CODEC;
    }
}

